# Guia de Instalação - Landing Page Builder

## Instalação Local para Desenvolvimento

### Pré-requisitos

Antes de iniciar, certifique-se de ter instalado:

- **PHP 8.1 ou superior** com as seguintes extensões:
  - OpenSSL
  - PDO
  - Mbstring
  - Tokenizer
  - XML
  - Ctype
  - JSON
  - BCMath
  - Fileinfo
  - SQLite (se usar SQLite)

- **Composer** (gerenciador de dependências PHP)
- **Node.js 18 ou superior**
- **pnpm** (recomendado) ou npm
- **Git** para controle de versão

### Passo 1: Configuração do Backend (Laravel)

1. **Clone ou extraia os arquivos do projeto:**
   ```bash
   # Se usando Git
   git clone [URL_DO_REPOSITORIO]
   cd landing-page-builder
   
   # Ou extraia o arquivo ZIP e navegue para a pasta
   cd landing-page-builder
   ```

2. **Instale as dependências do PHP:**
   ```bash
   composer install
   ```

3. **Configure o arquivo de ambiente:**
   ```bash
   # Copie o arquivo de exemplo
   cp .env.example .env
   
   # Edite o arquivo .env com suas configurações
   nano .env  # ou use seu editor preferido
   ```

   **Configurações importantes no .env:**
   ```env
   APP_NAME="Landing Page Builder"
   APP_ENV=local
   APP_KEY=
   APP_DEBUG=true
   APP_URL=http://localhost:8000

   DB_CONNECTION=sqlite
   # Para SQLite, comente as linhas MySQL:
   #DB_HOST=127.0.0.1
   #DB_PORT=3306
   #DB_DATABASE=laravel
   #DB_USERNAME=root
   #DB_PASSWORD=

   JWT_SECRET=
   ```

4. **Gere as chaves necessárias:**
   ```bash
   # Gerar chave da aplicação
   php artisan key:generate
   
   # Gerar chave JWT
   php artisan jwt:secret
   ```

5. **Crie o banco de dados SQLite:**
   ```bash
   touch database/database.sqlite
   ```

6. **Execute as migrações:**
   ```bash
   php artisan migrate
   ```

7. **Execute os seeders para dados iniciais:**
   ```bash
   php artisan db:seed --class=DefaultTemplateSeeder
   ```

8. **Inicie o servidor Laravel:**
   ```bash
   php artisan serve --host=0.0.0.0 --port=8000
   ```

   O backend estará disponível em: `http://localhost:8000`

### Passo 2: Configuração do Frontend (React)

1. **Navegue para o diretório do frontend:**
   ```bash
   cd ../landing-page-frontend
   ```

2. **Instale as dependências:**
   ```bash
   # Usando pnpm (recomendado)
   pnpm install
   
   # Ou usando npm
   npm install
   ```

3. **Configure as variáveis de ambiente:**
   ```bash
   # Crie o arquivo de ambiente
   touch .env.local
   
   # Adicione a configuração da API
   echo "VITE_API_URL=http://localhost:8000/api" > .env.local
   ```

4. **Inicie o servidor de desenvolvimento:**
   ```bash
   # Usando pnpm
   pnpm run dev
   
   # Ou usando npm
   npm run dev
   ```

   O frontend estará disponível em: `http://localhost:5173`

### Passo 3: Verificação da Instalação

1. **Teste o Backend:**
   - Acesse: `http://localhost:8000/api/templates`
   - Deve retornar um JSON com os templates disponíveis

2. **Teste o Frontend:**
   - Acesse: `http://localhost:5173`
   - Deve exibir a página inicial do Landing Page Builder

3. **Teste a Integração:**
   - Clique em "Ver Página Demo" no frontend
   - Deve carregar uma página de exemplo

## Instalação em Produção

### Opção 1: Servidor VPS/Dedicado

#### Configuração do Servidor

1. **Instale as dependências do sistema:**
   ```bash
   # Ubuntu/Debian
   sudo apt update
   sudo apt install php8.1 php8.1-fpm php8.1-mysql php8.1-xml php8.1-mbstring php8.1-curl php8.1-zip php8.1-sqlite3
   sudo apt install nginx mysql-server composer nodejs npm
   
   # CentOS/RHEL
   sudo yum install php php-fpm php-mysql php-xml php-mbstring php-curl php-zip php-sqlite3
   sudo yum install nginx mysql-server composer nodejs npm
   ```

2. **Configure o Nginx:**
   ```nginx
   # /etc/nginx/sites-available/napoleon.com.br
   server {
       listen 80;
       server_name napoleon.com.br www.napoleon.com.br;
       root /var/www/napoleon/frontend/dist;
       index index.html;

       location / {
           try_files $uri $uri/ /index.html;
       }
   }

   # /etc/nginx/sites-available/api.napoleon.com.br
   server {
       listen 80;
       server_name api.napoleon.com.br;
       root /var/www/napoleon/backend/public;
       index index.php;

       location / {
           try_files $uri $uri/ /index.php?$query_string;
       }

       location ~ \.php$ {
           fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
           fastcgi_index index.php;
           fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
           include fastcgi_params;
       }
   }
   ```

3. **Configure SSL com Let's Encrypt:**
   ```bash
   sudo apt install certbot python3-certbot-nginx
   sudo certbot --nginx -d napoleon.com.br -d www.napoleon.com.br
   sudo certbot --nginx -d api.napoleon.com.br
   ```

#### Deploy da Aplicação

1. **Prepare o Backend:**
   ```bash
   cd /var/www/napoleon/backend
   composer install --optimize-autoloader --no-dev
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   php artisan migrate --force
   php artisan db:seed --class=DefaultTemplateSeeder --force
   ```

2. **Prepare o Frontend:**
   ```bash
   cd /var/www/napoleon/frontend
   npm install
   npm run build
   ```

### Opção 2: cPanel/Hospedagem Compartilhada

#### Preparação dos Arquivos

1. **Build Local:**
   ```bash
   # Backend
   cd landing-page-builder
   composer install --optimize-autoloader --no-dev
   
   # Frontend
   cd ../landing-page-frontend
   npm run build
   ```

2. **Estrutura de Upload:**
   ```
   public_html/
   ├── index.html (do build do frontend)
   ├── assets/ (do build do frontend)
   └── api/
       └── [arquivos do Laravel]
   ```

#### Configuração no cPanel

1. **Upload dos Arquivos:**
   - Faça upload do conteúdo da pasta `dist` do frontend para `public_html`
   - Faça upload dos arquivos do Laravel para `public_html/api`

2. **Configuração do Banco:**
   - Crie um banco MySQL no cPanel
   - Configure as credenciais no arquivo `.env`
   - Execute as migrações via terminal ou script

3. **Configuração de Subdomínio:**
   - Crie o subdomínio `api.napoleon.com.br`
   - Aponte para a pasta `public_html/api/public`

### Configuração Específica para napoleon.com.br

#### Estrutura Recomendada

```
napoleon.com.br/
├── (arquivos do frontend React)
└── api.napoleon.com.br/
    └── (API Laravel)
```

#### Variáveis de Ambiente para Produção

**Backend (.env):**
```env
APP_NAME="Napoleon Landing Page Builder"
APP_ENV=production
APP_KEY=[CHAVE_GERADA]
APP_DEBUG=false
APP_URL=https://api.napoleon.com.br

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=napoleon_lpb
DB_USERNAME=[SEU_USUARIO]
DB_PASSWORD=[SUA_SENHA]

JWT_SECRET=[CHAVE_JWT_GERADA]

CORS_ALLOWED_ORIGINS=https://napoleon.com.br,https://www.napoleon.com.br
```

**Frontend (.env.production):**
```env
VITE_API_URL=https://api.napoleon.com.br/api
```

## Solução de Problemas Comuns

### Erro: "Class not found"
```bash
# Regenere o autoload
composer dump-autoload
```

### Erro: "Permission denied"
```bash
# Configure permissões corretas
sudo chown -R www-data:www-data /var/www/napoleon
sudo chmod -R 755 /var/www/napoleon
sudo chmod -R 775 storage bootstrap/cache
```

### Erro: "CORS policy"
- Verifique se o domínio está configurado corretamente no backend
- Configure as origens permitidas no arquivo `config/cors.php`

### Erro: "JWT secret not set"
```bash
php artisan jwt:secret
```

### Frontend não carrega
- Verifique se a URL da API está correta no `.env`
- Confirme se o backend está respondendo
- Verifique os logs do navegador para erros JavaScript

## Manutenção Pós-Instalação

### Backups Regulares

1. **Banco de Dados:**
   ```bash
   # MySQL
   mysqldump -u usuario -p napoleon_lpb > backup_$(date +%Y%m%d).sql
   
   # SQLite
   cp database/database.sqlite backup_$(date +%Y%m%d).sqlite
   ```

2. **Arquivos:**
   ```bash
   tar -czf backup_files_$(date +%Y%m%d).tar.gz /var/www/napoleon
   ```

### Atualizações

1. **Backend:**
   ```bash
   composer update
   php artisan migrate
   php artisan config:cache
   ```

2. **Frontend:**
   ```bash
   npm update
   npm run build
   ```

### Monitoramento

- Configure logs de erro do Nginx/Apache
- Monitore logs do Laravel em `storage/logs/`
- Configure alertas para erros críticos
- Monitore uso de recursos do servidor

## Suporte

Para suporte técnico ou dúvidas sobre a instalação:

1. Verifique os logs de erro primeiro
2. Consulte a documentação completa no README.md
3. Teste em ambiente local antes de aplicar em produção
4. Mantenha backups atualizados antes de qualquer alteração

A instalação está completa quando ambos os serviços (frontend e backend) estão funcionando corretamente e se comunicando entre si.

