# Instalação Automática - Landing Page Builder

## Visão Geral do Instalador

O Landing Page Builder inclui um sistema de instalação automática baseado em web que simplifica drasticamente o processo de deploy. Este instalador foi desenvolvido para permitir que usuários sem conhecimento técnico avançado possam instalar o sistema completo em qualquer servidor web compatível.

### Características do Instalador

- **Interface Web Intuitiva**: Processo guiado em 5 etapas simples
- **Verificação Automática**: Checagem completa de requisitos do sistema
- **Configuração Assistida**: Setup automático do banco de dados e configurações
- **Validação em Tempo Real**: Testes de conectividade e validação de dados
- **Instalação Segura**: Geração automática de chaves de segurança
- **Feedback Visual**: Indicadores de progresso e mensagens claras

## Como Usar o Instalador

### Passo 1: Upload dos Arquivos

1. **Descompacte o arquivo ZIP** do Landing Page Builder no seu computador
2. **Faça upload** de todos os arquivos para o diretório raiz do seu domínio (lpg.impressone.app.br)
3. **Configure as permissões** necessárias (o instalador verificará automaticamente)

### Passo 2: Acesse o Instalador

1. **Abra seu navegador** e acesse: `https://lpg.impressone.app.br/install/`
2. **O instalador será iniciado automaticamente** se o sistema ainda não estiver configurado
3. **Siga as instruções** apresentadas na tela

### Passo 3: Verificação de Requisitos

O instalador verificará automaticamente:

- **PHP 8.1 ou superior**: Versão mínima necessária
- **Extensões PHP**: PDO, JSON, Mbstring, OpenSSL, etc.
- **Permissões de Diretório**: Verificação de escrita nas pastas necessárias
- **Dependências**: Verificação se o Composer foi executado
- **Configuração do Servidor**: Mod Rewrite e outras configurações

### Passo 4: Configuração do Banco de Dados

Escolha entre duas opções:

#### Opção A: MySQL/MariaDB
- **Host**: Normalmente `localhost`
- **Porta**: Geralmente `3306`
- **Nome do Banco**: Nome do banco de dados (será criado se não existir)
- **Usuário**: Usuário do banco com privilégios de criação
- **Senha**: Senha do usuário do banco

#### Opção B: SQLite
- **Configuração Automática**: Não requer configuração adicional
- **Arquivo Local**: Banco será criado automaticamente
- **Ideal para**: Sites pequenos e médios

### Passo 5: Configuração do Site

- **Nome do Site**: "Landing Page Builder" (ou personalize)
- **URL do Site**: `https://lpg.impressone.app.br`
- **Email do Admin**: Seu email para acesso administrativo
- **Senha do Admin**: Senha segura (mínimo 8 caracteres)

### Passo 6: Instalação Automática

O sistema executará automaticamente:

1. **Criação do arquivo .env** com todas as configurações
2. **Configuração do banco de dados** e criação das tabelas
3. **Execução das migrações** para estrutura do banco
4. **Criação do usuário administrador** com suas credenciais
5. **Instalação dos templates padrão** e dados iniciais
6. **Configuração de permissões** e cache do sistema
7. **Finalização** e criação do arquivo de bloqueio

## Estrutura de Arquivos para Upload

Quando descompactar o arquivo ZIP, você terá a seguinte estrutura:

```
landing-page-builder/
├── app/                    # Código da aplicação Laravel
├── bootstrap/              # Arquivos de inicialização
├── config/                 # Arquivos de configuração
├── database/               # Migrações e seeders
├── install/                # Sistema de instalação automática
│   ├── index.php          # Interface principal do instalador
│   ├── installer.js       # JavaScript do instalador
│   ├── check.php          # Verificação de requisitos
│   ├── database.php       # Configuração do banco
│   └── config.php         # Configuração do sistema
├── public/                 # Arquivos públicos (DocumentRoot)
├── resources/              # Views e assets
├── routes/                 # Definições de rotas
├── storage/                # Arquivos de cache e logs
├── vendor/                 # Dependências do Composer
├── .env.example           # Exemplo de configuração
├── artisan                # CLI do Laravel
├── composer.json          # Dependências PHP
└── README.md              # Documentação
```

## Configuração do Servidor Web

### Para Apache (.htaccess)

O sistema inclui arquivos `.htaccess` pré-configurados:

```apache
# Redirecionar para o instalador se não estiver instalado
RewriteEngine On
RewriteCond %{REQUEST_URI} !^/install/
RewriteCond %{DOCUMENT_ROOT}/../.env !-f
RewriteRule ^(.*)$ /install/ [R=302,L]

# Prevenir acesso ao instalador após instalação
RewriteCond %{REQUEST_URI} ^/install/
RewriteCond %{DOCUMENT_ROOT}/../.env -f
RewriteCond %{DOCUMENT_ROOT}/../storage/installed.lock -f
RewriteRule ^(.*)$ / [R=302,L]
```

### Para Nginx

Adicione ao seu arquivo de configuração:

```nginx
# Redirecionar para instalador se necessário
location / {
    if (!-f $document_root/../.env) {
        return 302 /install/;
    }
    try_files $uri $uri/ /index.php?$query_string;
}

# Bloquear acesso ao instalador após instalação
location /install/ {
    if (-f $document_root/../.env) {
        if (-f $document_root/../storage/installed.lock) {
            return 302 /;
        }
    }
    try_files $uri $uri/ /install/index.php?$query_string;
}
```

## Configuração Específica para lpg.impressone.app.br

### Estrutura Recomendada no Servidor

```
public_html/
├── (arquivos do diretório public/ do Laravel)
├── install/               # Sistema de instalação
└── landing-page-builder/  # Resto da aplicação Laravel
```

### Configuração do .htaccess Principal

No diretório raiz (`public_html/`):

```apache
RewriteEngine On

# Redirecionar para instalador se não configurado
RewriteCond %{DOCUMENT_ROOT}/landing-page-builder/.env !-f
RewriteCond %{REQUEST_URI} !^/install/
RewriteRule ^(.*)$ /install/ [R=302,L]

# Processar rotas normais do Laravel
RewriteCond %{REQUEST_FILENAME} !-d
RewriteCond %{REQUEST_FILENAME} !-f
RewriteRule ^ index.php [L]
```

### Variáveis de Ambiente Específicas

O instalador configurará automaticamente:

```env
APP_NAME="Landing Page Builder - Impressone"
APP_URL=https://lpg.impressone.app.br
LPB_DOMAIN=https://lpg.impressone.app.br
LPB_ADMIN_EMAIL=seu-email@impressone.app.br
```

## Solução de Problemas do Instalador

### Erro: "Requisitos não atendidos"

**Problema**: Alguns requisitos do sistema não foram atendidos.

**Soluções**:
- Verifique a versão do PHP (mínimo 8.1)
- Instale extensões PHP faltantes
- Configure permissões de escrita nas pastas
- Execute `composer install` se necessário

### Erro: "Não foi possível conectar ao banco"

**Problema**: Falha na conexão com o banco de dados.

**Soluções**:
- Verifique as credenciais do banco
- Confirme se o banco de dados existe
- Teste a conectividade manualmente
- Verifique se o usuário tem privilégios necessários

### Erro: "Arquivo .env não pode ser criado"

**Problema**: Permissões insuficientes para criar arquivos.

**Soluções**:
- Configure permissões 755 no diretório raiz
- Verifique se o usuário web pode escrever
- Teste criação manual de arquivos

### Erro: "Migrações falharam"

**Problema**: Erro ao executar migrações do banco.

**Soluções**:
- Verifique se o banco está vazio
- Confirme privilégios de CREATE TABLE
- Execute manualmente: `php artisan migrate`

## Segurança do Instalador

### Proteções Implementadas

1. **Bloqueio Automático**: Instalador se torna inacessível após instalação
2. **Validação de Dados**: Todos os inputs são validados e sanitizados
3. **Geração Segura**: Chaves de segurança geradas automaticamente
4. **Arquivo de Bloqueio**: Previne reinstalações acidentais

### Recomendações Pós-Instalação

1. **Remova a pasta install/**: Após instalação bem-sucedida
2. **Configure SSL**: Certifique-se de usar HTTPS
3. **Backup Regular**: Configure backups automáticos
4. **Atualizações**: Mantenha o sistema atualizado

## Personalização do Instalador

### Modificando a Interface

O arquivo `install/index.php` pode ser personalizado:

- **Cores e Estilos**: Modifique o CSS inline
- **Textos**: Altere mensagens e instruções
- **Validações**: Adicione verificações específicas
- **Etapas**: Customize o fluxo de instalação

### Adicionando Verificações Customizadas

No arquivo `install/check.php`:

```php
// Adicionar verificação customizada
$requirements['custom_check'] = [
    'name' => 'Verificação Customizada',
    'status' => your_custom_check_function()
];
```

### Configurações Específicas do Domínio

No arquivo `install/config.php`, você pode pré-configurar valores:

```php
// Pré-configurar para lpg.impressone.app.br
$defaultConfig = [
    'site_url' => 'https://lpg.impressone.app.br',
    'site_name' => 'Landing Page Builder - Impressone'
];
```

## Manutenção do Sistema Instalado

### Verificação de Saúde

Após a instalação, você pode verificar a saúde do sistema:

```bash
# Verificar status geral
php artisan about

# Verificar configurações
php artisan config:show

# Verificar banco de dados
php artisan migrate:status
```

### Atualizações Futuras

Para atualizações do sistema:

1. **Backup**: Sempre faça backup antes
2. **Upload**: Substitua arquivos (exceto .env)
3. **Migrações**: Execute `php artisan migrate`
4. **Cache**: Limpe cache com `php artisan cache:clear`

### Monitoramento

Configure monitoramento para:

- **Logs de Erro**: `storage/logs/laravel.log`
- **Performance**: Tempo de resposta das páginas
- **Disponibilidade**: Status do site e banco
- **Segurança**: Tentativas de acesso não autorizadas

O instalador automático torna o processo de deploy do Landing Page Builder extremamente simples e acessível, permitindo que qualquer pessoa possa configurar o sistema completo em poucos minutos, independentemente do nível técnico.

