<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PageContent extends Model
{
    use HasFactory;

    protected $table = 'page_content';

    protected $fillable = [
        'landing_page_id',
        'section_type',
        'section_name',
        'content_data',
        'sort_order',
        'is_visible',
    ];

    protected $casts = [
        'content_data' => 'array',
        'is_visible' => 'boolean',
    ];

    /**
     * Get the landing page that owns the content.
     */
    public function landingPage(): BelongsTo
    {
        return $this->belongsTo(LandingPage::class);
    }

    /**
     * Scope a query to only include visible content.
     */
    public function scopeVisible($query)
    {
        return $query->where('is_visible', true);
    }
}

