<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TemplateSection extends Model
{
    use HasFactory;

    protected $fillable = [
        'template_id',
        'section_type',
        'section_name',
        'default_content',
        'sort_order',
        'is_required',
    ];

    protected $casts = [
        'default_content' => 'array',
        'is_required' => 'boolean',
    ];

    /**
     * Get the template that owns the section.
     */
    public function template(): BelongsTo
    {
        return $this->belongsTo(Template::class);
    }
}

