<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Template;
use App\Models\TemplateSection;

class DefaultTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create "Blocos de Construção" template
        $buildingBlocksTemplate = Template::firstOrCreate(
            [
                'id' => 999
            ],
            [
                'name' => 'Blocos de Construção',
                'description' => 'Template base com seções modulares para construção de páginas.',
                'category' => 'base',
                'is_active' => true,
            ]
        );

        // Define modular sections with default content
        $sections = [
            [
                'section_type' => 'hero',
                'section_name' => 'Hero Section',
                'default_content' => [
                    'title' => 'Seu Título Impactante Aqui',
                    'subtitle' => 'Subtítulo que descreve a proposta de valor.',
                    'button_text' => 'Chamada para Ação',
                    'button_link' => '#',
                    'image' => 'https://via.placeholder.com/1500x800?text=Hero+Image',
                ],
                'sort_order' => 10,
            ],
            [
                'section_type' => 'benefits',
                'section_name' => 'Seção de Benefícios',
                'default_content' => [
                    'title' => 'Benefícios Incríveis',
                    'items' => [
                        ['icon' => 'fa-check-circle', 'text' => 'Benefício 1'],
                        ['icon' => 'fa-check-circle', 'text' => 'Benefício 2'],
                        ['icon' => 'fa-check-circle', 'text' => 'Benefício 3'],
                    ],
                ],
                'sort_order' => 20,
            ],
            ['section_type' => 'testimonials',
                'section_name' => 'Depoimentos',
                'default_content' => [
                    'title' => 'O que nossos clientes dizem',
                    'testimonials' => [
                        ['quote' => 'Este produto mudou minha vida!', 'author' => 'Cliente Satisfeito'],
                    ],
                ],
                'sort_order' => 30,
            ],
            [
                'section_type' => 'cta',
                'section_name' => 'Chamada para Ação Final',
                'default_content' => [
                    'title' => 'Não Perca Mais Tempo!',
                    'subtitle' => 'Garanta já o seu.',
                    'button_text' => 'Comprar Agora',
                    'button_link' => '#',
                ],
                'sort_order' => 40,
            ],
            [
                'section_type' => 'footer',
                'section_name' => 'Rodapé',
                'default_content' => [
                    'text' => '© ' . date('Y') . ' Sua Empresa. Todos os direitos reservados.',
                    'links' => [
                        ['text' => 'Política de Privacidade', 'url' => '#'],
                        ['text' => 'Termos de Uso', 'url' => '#'],
                    ],
                ],
                'sort_order' => 50,
            ],
        ];

        foreach ($sections as $sectionData) {
            $buildingBlocksTemplate->sections()->firstOrCreate(
                [
                    'template_id' => $buildingBlocksTemplate->id,
                    'section_type' => $sectionData['section_type'],
                ],
                $sectionData
            );
        }
    }
}
