<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\LandingPageController;
use App\Http\Controllers\TemplateController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public Routes
Route::get(
    '/public/page/{slug}',
    [LandingPageController::class, 'showPublicPage']
)->name(
    'public.page.show'
);

// Authentication Routes
Route::group([
    'middleware' => 'api',
    'prefix' => 'auth'
], function ($router) {
    Route::post(
        'login',
        [AuthController::class, 'login']
    );
    Route::post(
        'logout',
        [AuthController::class, 'logout']
    );
    Route::post(
        'refresh',
        [AuthController::class, 'refresh']
    );
    Route::post(
        'me',
        [AuthController::class, 'me']
    );
});

// Admin Routes
Route::group([
    'middleware' => 'auth:api',
    'prefix' => 'admin'
], function ($router) {
    // Landing Pages
    Route::apiResource(
        'pages',
        LandingPageController::class
    );
    Route::post(
        'pages/{landingPage}/publish',
        [LandingPageController::class, 'publish']
    )->name(
        'pages.publish'
    );
    Route::post(
        'pages/{landingPage}/create-variant',
        [LandingPageController::class, 'createVariant']
    )->name(
        'pages.create-variant'
    );
});

// Templates (public for testing)
Route::apiResource(
    'templates',
    TemplateController::class
);
